#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Cairo tilingMod01.fsh   by  Nimitz  
//https://www.shadertoy.com/view/4ssSWf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Cairo tiling by nimitz (stormoid.com) (twitter: @stormoid)

//Inspired by Petri Leskinen's "Cairo Pentagonal Tiling" http://pixelero.wordpress.com/page/2/

/*
	Cairo pentagonal tiling made using a "voronoi-like" function,
	the main difference is that half the tiles are reflected and the centers are
	displaced symmetrically.

	Please let me know if you can think of a simple way to get all the edges.
*/

#define time iTime*0.5
float hash( float n ){ return fract(sin(n)*43758.5453);}


//returns: x -> distance form center | y -> cell id | z -> distance from edge
vec3 field(const in vec2 p)
{
    vec2 fp = fract(p);
    vec2 ip = floor(p);
    
    vec3 rz = vec3(1.);
    
    //vary the offset over time
    float of = sin(time*0.6)*.5;
    
    //reflect
   	float rf = mod(ip.x+ip.y,2.0);
    fp.x = rf-fp.x*sign(rf-.5);
    
	for(float j=0.; j<=1.; j++)
	for(float i=0.; i<=1.; i++)
    {
        vec2 b = vec2(j, i);
        
        //Displace each sample
        float sgn = sign(j-0.5); 
        float cmp = float(j == i);
        vec2 o = vec2(sgn*cmp,-sgn*(1.-cmp));
        //o = b-vec2(i,j); //variation
        vec2 sp = fp - b + of*o;
        b += o;
        
        float d = dot(sp,sp);
        
        if( d<rz.x )
        {
            rz.z = rz.x;
            rz.x = d;
            b.x = rf-b.x*sign(rf-.5);
        	rz.y = hash( dot(ip+b,vec2(7.0,113.0) ) );
        }
        else if( d<rz.z )
		{
            rz.z = d;
		}
    }
    
    //truncation
    float d = dot(fp-.5,fp-.5);
    d += 0.4; //truncation weight
    if (d < rz.x)
    {
        rz.z = rz.x;
        rz.x = d;
        rz.y = hash( dot(ip,vec2(7.0,113.0) ) );
    }
    else if(d < rz.z )
	{
    	rz.z = d;
	}
    
    //F2-F1 edge detection
    rz.z = rz.z-rz.x;
    
    return rz;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 p = fragCoord.xy / iResolution.xy;
	p.x *= iResolution.x/iResolution.y;
    float a = sin(time)*.5;
    float b = .5;
    
    p *= 6.+sin(time*0.4);
    p.x += time;
    p.y += sin(time)*0.5;
    
    vec3 rz = field(p);
    
    vec3 col = (sin(vec3(.2,.55,.8)+rz.y*4.+2.)+0.4)*0.6+0.5;
    col *= 1.-rz.x;
    col *= smoothstep(0.,.04,rz.z);
    
    fragColor = vec4(col,1.0);
    
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

